/***********************************************************************/
/*  This file is part of the ARM Toolchain package                     */
/*  Copyright KEIL ELEKTRONIK GmbH 2011                                */
/***********************************************************************/
/*                                                                     */
/*  FlashDev.c:  Device Description for ES32F0xx Flash                 */
/*                                                                     */ 
/*          Change Logs:
 *          Date            Author          Notes
 *          30 Apri 2021    biyq            the first version
************************************************************************/
/* Includes ------------------------------------------------------------------ */
#ifdef OutputDebugInfo

#include "debugModule.h"
#include <string.h>

/* Private Macros ------------------------------------------------------------ */

/* Private Variables --------------------------------------------------------- */

/* Public Variables ---------------------------------------------------------- */

uart_handle_t g_uart_handle;

/* Private Constants --------------------------------------------------------- */

/* Private function prototypes ----------------------------------------------- */

/* Private Function ---------------------------------------------------------- */

/**
  * @brief  Initializate pin of uart module.
  * @retval None
  */
void uart_pin_init(void)
{
    gpio_init_t gpio_config;
    memset(&gpio_config, 0x00, sizeof(gpio_init_t));

    /* Initialize tx pin: PC0 */
    gpio_config.mode = GPIO_MODE_OUTPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOC, GPIO_PIN_0, &gpio_config);

    /* Initialize rx pin: PC1 */
    gpio_config.mode = GPIO_MODE_INPUT;
    gpio_config.odos = GPIO_PUSH_PULL;
    gpio_config.pupd = GPIO_PUSH_UP;
    gpio_config.podrv = GPIO_OUT_DRIVE_1;
    gpio_config.nodrv = GPIO_OUT_DRIVE_0_1;
    gpio_config.flt  = GPIO_FILTER_DISABLE;
    gpio_config.type = GPIO_TYPE_TTL;
    gpio_config.func = GPIO_FUNC_3;
    ald_gpio_init(GPIOC, GPIO_PIN_1, &gpio_config);

    return;
}

/**
  * @brief  initialization function to init the one which output debug information 
  * @retval Status.
  */
int Debug_Output_Init(void)
{

    /* Initialize ALD */
    ald_cmu_perh_clock_config(CMU_PERH_UART1, ENABLE);

    /* Initialize pin */
    uart_pin_init();

    memset(&g_uart_handle, 0x00, sizeof(uart_handle_t));
    /* Initialize uart */
    g_uart_handle.perh             = UART1;
    g_uart_handle.init.baud        = 115200;
    g_uart_handle.init.word_length = UART_WORD_LENGTH_8B;
    g_uart_handle.init.stop_bits   = UART_STOP_BITS_1;
    g_uart_handle.init.parity      = UART_PARITY_NONE;
    g_uart_handle.init.mode        = UART_MODE_UART;
    g_uart_handle.init.fctl        = UART_HW_FLOW_CTL_DISABLE;
    ald_uart_init(&g_uart_handle);

    ald_uart_tx_fifo_config(&g_uart_handle, UART_TXFIFO_EMPTY);

    return 0;
}

/********************************************************************************************
*
*   Don't Need to Modify
*
********************************************************************************************/
/**
  * @brief  output debug information
  * @retval Status.
  */
void DebugPrintf(const char *pointer, ...)
{
    unsigned char i, size;
    char buffer[4096];
    FILE * f = NULL;
    va_list ap;

    uart_pin_init();

    va_start(ap, pointer);

    size = vsprintf(buffer, pointer, ap);

    va_end(ap);

    for (i = 0; i < size; i++)
        fputc(buffer[i], f);

    return;
}

/**
  * @brief  override default function
  * @retval Status.
  */
int fputc(int ch, FILE *f)
{
    uint32_t count = 0UL;
    uint8_t status = RESET;

    SEND_BYTE(ch);

    do
    {
        status = CRITICIZE_FLAG();
        count++;
    }
    while ((status == RESET) && (count != 0x1CE2));

    CLR_SEND_OVER_FLAG();

    if (count == 0x1CE2)
        return -1;
    else
        return 0;
}

/**
  * @}
  */
/**
  * @}
  */

#endif	/* OutputDebugInfo */

/************* (C) COPYRIGHT Eastsoft Microelectronics *****END OF FILE****/
